/**
 * \file: mspin_lm_adapter_typedef.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MySpin LayerManager Adapter Types
 *
 * \component: MSPIN
 *
 * \author: Thilo Bjoern Fickel BSOT/PJ-ES thilobjoern.fickel@bosch-softtec.com
 *
 * \copyright: (c) 2015 Bosch SoftTec
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

/***********************************************************************/
/***********                 DO NOT MODIFY!                 ************/
/***********************************************************************/
/*                                                                     */
/* In case you need own definitions/variables please add them to the   *
 * internal part of your LayerManager adapter implementation. If the   *
 * context variable has to be extended, please extend                  *
 * 'mspin_lm_context_internal' (see below for more details)            */
/***********************************************************************/

#ifndef MSPIN_LM_ADAPTER_TYPEDEF_H_
#define MSPIN_LM_ADAPTER_TYPEDEF_H_

#ifdef  __cplusplus
extern "C"
{
#endif

#ifdef PROJECTBUILD_NISSAN_LCN2
#include <adit_typedef.h>
#else
#include <adit-system/adit_typedef.h>
#endif

#include <stdbool.h>
#include <semaphore.h>
#include "mspin_appl_if_adapter.h"

enum mspin_lm_flags
{
    MSPIN_WL_DISABLE_TOUCHEVENTS = 0x0,
    MSPIN_WL_ENABLE_TOUCHEVENTS = 0x1,
};

//mspin_lm_context_internal has to be defined within the implementation of LayerManager adapter.
//Variables which are required with every call have to be added to the internal structure mspin_lm_context_internal.
//ToDo: Rename to make it clear that this is the internal handle
typedef struct mspin_wl_context mspin_wl_context_t;

/**
 * The layerManager context.
 * The context defines variables used by mySPIN Target Adapter.
 * All LayerManager adapter specific variables which are required to be forwarded with every context, need to be added
 * to the LM adapter internal structure mspin_lm_context_internal.
 */
struct mspin_layerManager_context
{
    bool useWaylandTouch;
    bool useTouchFiltering;
    bool usePointerFiltering;
    MSPIN_PIXEL_FORMAT pixelFormat;
    U32 bytesPerPixel;
    U32 frameWidth;
    U32 frameHeight;
    U32 layerId;
    U32 surfaceId;

    void *pCoreHandle; //A handle to the mySPIN Core instance
    mspin_wl_context_t *pWLCtx;
    bool readyToUse;

    pthread_rwlock_t rwlock; // lock protects access to pWLCtx - to avoid deletion while it is in use
};

typedef struct mspin_layerManager_context mspin_layerManager_context_t;

#ifdef __cplusplus
}
#endif

#endif /* MSPIN_LM_ADAPTER_TYPEDEF_H_ */
